// SketcherView.cpp : Implementacja klasy CSketcherView
//

#include "stdafx.h"
#include "Sketcher.h"

#include "SketcherDoc.h"
#include "Elements.h"
#include "SketcherView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSketcherView

IMPLEMENT_DYNCREATE(CSketcherView, CView)

BEGIN_MESSAGE_MAP(CSketcherView, CView)
	// Standardowe polecenia drukowania
	ON_COMMAND(ID_FILE_PRINT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, &CView::OnFilePrintPreview)
  ON_WM_LBUTTONUP()
  ON_WM_LBUTTONDOWN()
  ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()

// Konstrukcja/destrukcja CSketcherView

CSketcherView::CSketcherView()
: m_FirstPoint(0,0)
, m_SecondPoint(0,0)
, m_pTempElement(NULL)
{
	// TODO: add construction code here

}

CSketcherView::~CSketcherView()
{
}

BOOL CSketcherView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

// Rysowanie CSketcherView

void CSketcherView::OnDraw(CDC* pDC)
{
	CSketcherDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	// TODO: add draw code for native data here
}

// Drukowanie CSketcherView

BOOL CSketcherView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CSketcherView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CSketcherView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}


// Diagnostyka CSketcherView

#ifdef _DEBUG
void CSketcherView::AssertValid() const
{
	CView::AssertValid();
}

void CSketcherView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CSketcherDoc* CSketcherView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSketcherDoc)));
	return (CSketcherDoc*)m_pDocument;
}
#endif //_DEBUG


// Procedury obsugi komunikatw CSketcherView

void CSketcherView::OnLButtonUp(UINT nFlags, CPoint point)
{
    if(this == GetCapture())
      ReleaseCapture();        // Stop capturing mouse messages

  // Make sure there is an element
   if(m_pTempElement)
   {
      // Call a document class function to store the element
      // pointed to by m_pTempElement in the document object

      delete m_pTempElement;           // This code is temporary
      m_pTempElement = 0;              // Reset the element pointer
   }
}

void CSketcherView::OnLButtonDown(UINT nFlags, CPoint point)
{
  // TODO: Add your message handler code here and/or call default
   m_FirstPoint = point;               // Record the cursor position
   SetCapture();                       // Capture subsequent mouse messages
}

void CSketcherView::OnMouseMove(UINT nFlags, CPoint point)
{
   // Definiuje obiekt kontekstu urzdzenia dla widoku.
   CClientDC aDC(this);                // Kontekst urzdzenia dla tego widoku.
   aDC.SetROP2(R2_NOTXORPEN);          // Ustaw tryb rysowania
   if((nFlags & MK_LBUTTON) && (this == GetCapture()))
   {
      m_SecondPoint = point;           // Zapisz biec pozycj kursora.

      if(m_pTempElement)
      {
         // Przerysuj stary element, aby znikn z widoku
         m_pTempElement->Draw(&aDC);
         delete m_pTempElement;        // Usu stary element.
         m_pTempElement = 0;           // Zeruj wskanik.
      }

      // Utwrz tymczasowy element o typie i kolorze
      // zapisanymi w dokumencie, a nastpnie go narysuj.
      m_pTempElement = CreateElement();// Utwrz nowy element.
      m_pTempElement->Draw(&aDC);      // Rysuj element.
   }
}

// Utwrz nowy element na stercie
CElement* CSketcherView::CreateElement(void)
{
   // Pobierz wskanik do dokumentu dla tego widoku
   CSketcherDoc* pDoc = GetDocument();
   ASSERT_VALID(pDoc);                 // Verify the pointer is good

   // Now select the element using the type stored in the document
   switch(pDoc->GetElementType())
   {
      case RECTANGLE:
         return new CRectangle(m_FirstPoint, m_SecondPoint,
                                             pDoc->GetElementColor());

      case CIRCLE:
         return new CCircle(m_FirstPoint, m_SecondPoint,
                                          pDoc->GetElementColor());

      case CURVE:
         return new CCurve(pDoc->GetElementColor());

      case LINE:
         return new CLine(m_FirstPoint, m_SecondPoint,
                                        pDoc->GetElementColor());

      default:
         // Something's gone wrong
         AfxMessageBox(_T("Bad Element code"), MB_OK);
         AfxAbort();
         return NULL;
   }
}
